/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.permission.PermissionValidator;
import com.cobblemon.mod.common.api.pokemon.moves.LearnsetQuery;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.MoveArgumentType;
import com.cobblemon.mod.common.command.argument.PartySlotArgumentType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/command/TeachCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/class_3222;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;)I", "", "NAME", "Ljava/lang/String;", "PLAYER", "SLOT", "MOVE", "Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "ALREADY_KNOWS_EXCEPTION", "Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "CANT_LEARN_EXCEPTION", "common"})
@SourceDebugExtension(value={"SMAP\nTeachCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeachCommand.kt\ncom/cobblemon/mod/common/command/TeachCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1761#2,3:81\n*S KotlinDebug\n*F\n+ 1 TeachCommand.kt\ncom/cobblemon/mod/common/command/TeachCommand\n*L\n59#1:81,3\n*E\n"})
public final class TeachCommand {
    @NotNull
    public static final TeachCommand INSTANCE = new TeachCommand();
    @NotNull
    private static final String NAME = "teach";
    @NotNull
    private static final String PLAYER = "player";
    @NotNull
    private static final String SLOT = "slot";
    @NotNull
    private static final String MOVE = "move";
    @NotNull
    private static final Dynamic2CommandExceptionType ALREADY_KNOWS_EXCEPTION = new Dynamic2CommandExceptionType(TeachCommand::ALREADY_KNOWS_EXCEPTION$lambda$0);
    @NotNull
    private static final Dynamic2CommandExceptionType CANT_LEARN_EXCEPTION = new Dynamic2CommandExceptionType(TeachCommand::CANT_LEARN_EXCEPTION$lambda$0);

    private TeachCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getTEACH(), false, 2, null)).then(class_2170.method_9244((String)PLAYER, (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)SLOT, (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(class_2170.method_9244((String)MOVE, (ArgumentType)MoveArgumentType.Companion.move()).executes(TeachCommand::register$lambda$0))));
        dispatcher.register(command);
    }

    private final int execute(CommandContext<class_2168> context, class_3222 player) {
        MoveTemplate move;
        Pokemon pokemon;
        block15: {
            block14: {
                boolean bl;
                block13: {
                    Object it;
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block12: {
                        pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, SLOT, player);
                        move = MoveArgumentType.Companion.getMove(context, MOVE);
                        PermissionValidator permissionValidator = Cobblemon.INSTANCE.getPermissionValidator();
                        Object object = context.getSource();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
                        if (!permissionValidator.hasPermission((class_2168)object, CobblemonPermissions.getTEACH_BYPASS_LEARNSET()) && !LearnsetQuery.Companion.getANY().canLearn(move, pokemon.getForm().getMoves())) {
                            CommandSyntaxException commandSyntaxException = CANT_LEARN_EXCEPTION.create((Object)Pokemon.getDisplayName$default(pokemon, false, 1, null), (Object)move.getDisplayName());
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                            throw (Throwable)commandSyntaxException;
                        }
                        $this$any$iv = pokemon.getMoveSet().getMoves();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (Move)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)((Move)it).getTemplate(), (Object)move)) continue;
                                bl2 = true;
                                break block12;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block14;
                    $this$any$iv = pokemon.getBenchedMoves();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (BenchedMove)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)((BenchedMove)it).getMoveTemplate(), (Object)move)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block15;
            }
            CommandSyntaxException commandSyntaxException = ALREADY_KNOWS_EXCEPTION.create((Object)Pokemon.getDisplayName$default(pokemon, false, 1, null), (Object)move.getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        boolean bl = pokemon.getMoveSet().hasSpace() ? pokemon.getMoveSet().add(move.create()) : pokemon.getBenchedMoves().add(new BenchedMove(move, 0));
        Object[] objectArray = new Object[3];
        objectArray[0] = pokemon.getSpecies().getTranslatedName();
        Intrinsics.checkNotNullExpressionValue((Object)player.method_5477(), (String)"getName(...)");
        objectArray[2] = move.getDisplayName();
        class_5250 pokemonLearntMessage = LocalizationUtilsKt.commandLang(NAME, objectArray);
        ((class_2168)context.getSource()).method_9226(() -> TeachCommand.execute$lambda$2(pokemonLearntMessage), true);
        class_3222 class_32222 = ((class_2168)context.getSource()).method_44023();
        if (!(class_32222 != null ? class_32222.equals((Object)player) : false)) {
            player.method_43496((class_2561)pokemonLearntMessage);
        }
        return 1;
    }

    private static final Message ALREADY_KNOWS_EXCEPTION$lambda$0(Object a, Object b) {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)a);
        objectArray[0] = a;
        Intrinsics.checkNotNull((Object)b);
        objectArray[1] = b;
        class_5250 class_52502 = LocalizationUtilsKt.commandLang("teach.already_knows", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"commandLang(...)");
        return (Message)TextKt.red(class_52502);
    }

    private static final Message CANT_LEARN_EXCEPTION$lambda$0(Object a, Object b) {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)a);
        objectArray[0] = a;
        Intrinsics.checkNotNull((Object)b);
        objectArray[1] = b;
        class_5250 class_52502 = LocalizationUtilsKt.commandLang("teach.cant_learn", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"commandLang(...)");
        return (Message)TextKt.red(class_52502);
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        class_3222 class_32222 = CommandContextExtensionsKt.player$default(it, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player$default(...)");
        return INSTANCE.execute((CommandContext<class_2168>)it, class_32222);
    }

    private static final class_2561 execute$lambda$2(class_5250 $pokemonLearntMessage) {
        return (class_2561)$pokemonLearntMessage;
    }
}

